//	SioSock Class
#ifndef _____PRO_FACE___MTOM_SIO_SOCKET_CLASS_HEADER_FILE____
#define _____PRO_FACE___MTOM_SIO_SOCKET_CLASS_HEADER_FILE____

#define READ_INTERVAL_TIMEOUT	MAXDWORD	// read interval timeout
#define READ_TOTAL_M			MAXDWORD	// read total timeout multiplier
#define READ_TOTAL_C			1			// read total timeout constant
#define WRITE_TOTAL_M			0			// write total timeout multiplier
#define WRITE_TOTAL_C			0	 		// write total timeout constant, in milliseconds

//Settings for flow control.
#define CTSFLOW TRUE	//enable monitoring of CTS for output flow control
#define DSRFLOW TRUE	//enable monitoring of DSR for output flow control
#define XON_LIM	10		//min number of bytes allowed in the input buffer before the XON char is sent
#define XOFF_LIM 10		//max number of bytes allowed in the input buffer before the XOFF char is sent
#define XON 0x11		//XON char
#define XOFF 0x13		//XOFF char
#define EOFCHAR EOF		//char used to signal the end of data

#define DEFAULT_BAUDRATE	9600
#define DEFAULT_BYTESIZE	8
#define DEFAULT_TXWAIT		0
#define DEFAULT_PARITY		PTY_EVEN
#define DEFAULT_STOPBITS	STB_1
#define DEFAULT_FLOW		FLW_DTRCTS

class CSioSock
{
public:
	CSioSock(LPMtoMPortConfig pstSio);
	~CSioSock(void);

	bool Open(LPMtoMPortConfig pstSio) ;
	bool Config(LPMtoMPortConfig pstSio) ;
	void Close(void) ;

	bool Read( LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead ) ;
	bool Write( LPVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWrite) ;

	bool IsOpen(void);

	bool BufferClear() ;

	bool Open(void) ;
	bool Config(void) ;

private :
	HANDLE m_hCom;				// COM handle
	MtoMPortConfig m_stConfig ;
};


#endif //	_____PRO_FACE___MTOM_SIO_SOCKET_CLASS_HEADER_FILE____